set_global_name("Campaign")


add_chapter("Academy", -1.1, 0.0)
add_chapter("Practice", -0.8, 0.0)
add_chapter("Advanced Academy", -0.4, -0.25)
add_chapter("Extras Tutorial", 0.0, -0.6)
add_chapter("Practicum", -0.4, 0.25)
add_chapter("Intermezzo", -0.2, 0.5)
add_chapter("Assembly I", 0.0, 0.25)
add_chapter("Assembly II", 0.4, 0.4)
add_chapter("Patterns", 0.4, 0.2)
add_chapter("Assembly III", 0.8, 0.4)
add_chapter("Dynamical Systems", 0.0, -0.25)
add_chapter("Advanced Dynamics", 0.4, -0.4)
add_chapter("Digitalia", 0.8, -0.6)
add_chapter("Nortalvania", 0.4, 0.0)
add_chapter("Arcana", 0.8, -0.2)
add_chapter("Sandbox", 1.1, 0.0)

add_level_to_chapter("Academy", "First Steps", -1.0, -0.4)
add_level_to_chapter("Academy", "Building Bridges", -0.8, 0.3)
add_level_to_chapter("Academy", "A Portal", -0.6, -0.25)
add_level_to_chapter("Academy", "Rotations and Flips", -0.4, 0.2)
add_level_to_chapter("Academy", "Portals!", -0.2, -0.15)
add_level_to_chapter("Academy", "More Portals!", 0.0, 0.1)
add_level_to_chapter("Academy", "Putting It Together", 0.2, 0.0)

add_level_path_require("First Steps", "Building Bridges")
add_level_path_require("Building Bridges", "A Portal")
add_level_path_require("A Portal", "Rotations and Flips")
add_level_path_require("Rotations and Flips", "Portals!")
add_level_path_require("Portals!", "More Portals!")
add_level_path_require("More Portals!", "Putting It Together")

add_level_to_chapter("Practice", "Portal Practice", -0.4, 0.0)
add_level_to_chapter("Practice", "The Box Exam", 0.4, 0.0)
add_level_to_chapter("Practice", "Column", -0.4, 0.4)
add_level_to_chapter("Practice", "MultiWeld", -0.4, -0.4)

add_level_path("Portal Practice", "The Box Exam")
add_level_path("Column", "The Box Exam")
add_level_path("MultiWeld", "The Box Exam")

add_level_to_chapter("Advanced Academy", "Sensitivity", -0.4, 0.0)
add_level_to_chapter("Advanced Academy", "Electric Motion", 0.0, 0.0)
add_level_to_chapter("Advanced Academy", "Mutex", 0.4, 0.0)

add_level_path_require("Sensitivity", "Electric Motion")
add_level_path_require("Electric Motion", "Mutex")

add_level_to_chapter("Extras Tutorial", "Pin", -0.4, 0.4)
add_level_to_chapter("Extras Tutorial", "Nodes", -0.4, -0.4)
add_level_to_chapter("Extras Tutorial", "Invisible Arms", 0.4, -0.4)
add_level_to_chapter("Extras Tutorial", "Resizer", 0.4, 0.4)

add_chapter_path("Academy", "Practice")
add_chapter_path("Practice", "Practicum")
add_chapter_path("Practice", "Advanced Academy")
add_chapter_path("Advanced Academy", "Assembly I")
add_chapter_path("Practicum", "Assembly I")
add_chapter_path("Advanced Academy", "Dynamical Systems")
add_chapter_path("Advanced Academy", "Extras Tutorial")
add_chapter_path("Practicum", "Dynamical Systems")
add_chapter_path("Practicum", "Intermezzo")
add_chapter_path("Assembly I", "Patterns")
add_chapter_path("Assembly I", "Assembly II")
add_chapter_path("Assembly I", "Nortalvania")
add_chapter_path("Dynamical Systems", "Nortalvania")
add_chapter_path("Dynamical Systems", "Advanced Dynamics")
add_chapter_path("Assembly II", "Assembly III")
add_chapter_path("Nortalvania", "Arcana")
add_chapter_path("Advanced Dynamics", "Arcana")
add_chapter_path("Advanced Dynamics", "Digitalia")

add_level_to_chapter("Sandbox", "Sandbox", 0.0, 0.0)

add_level_to_chapter("Intermezzo", "Quadsort", -0.4, 0.0)
add_level_to_chapter("Intermezzo", "Piston Mover", 0.0, -0.3)
add_level_to_chapter("Intermezzo", "Warpless Column", 0.0, 0.3)

set_next_level_hint("Sensitivity", {"Electric Motion", "Pin"})
set_next_level_hint("Electric Motion", "Mutex")
disallow_default_next_levels("Mutex");

add_level_to_chapter("Practicum", "L", -0.5, 0.0)
add_level_to_chapter("Practicum", "Rocket", 0.0, 0.0)
add_level_to_chapter("Practicum", "Separator", 0.5, 0.5)
add_level_to_chapter("Practicum", "Trident", 0.5, 0.0)
add_level_to_chapter("Practicum", "Assembly", 0.5, -0.5)

add_level_path_require("L", "Rocket")
add_level_path_require("Rocket", "Separator")
add_level_path_require("Rocket", "Assembly")
add_level_path_require("Rocket", "Trident")

set_next_level_hint("L", "Rocket")
set_next_level_hint("Rocket", {"Trident", "Separator"})

add_level_to_chapter("Assembly I", "Little Triangles", -0.5, -0.5)
add_level_to_chapter("Assembly I", "Sequencer", -0.5, -0.1)
add_level_to_chapter("Assembly I", "Color Box", -0.2, 0.1)
add_level_to_chapter("Assembly I", "Triangles", 0.1, -0.2)
add_level_to_chapter("Assembly I", "T", -0.2, -0.5)
add_level_to_chapter("Assembly I", "S", 0.15, -0.5)
add_level_to_chapter("Assembly I", "H", 0.5, -0.5)

set_next_level_hint("Sequencer", "T")
set_next_level_hint("T", "S")
set_next_level_hint("S", "Triangles")
set_next_level_hint("Triangles", {"Color Box", "S", "H"})
set_next_level_hint("Color Box", {"T", "S", "H"})

add_level_path_require("Sequencer", "T")
add_level_path_require("Little Triangles", "T")
add_level_path_require("Sequencer", "Color Box")
add_level_path_require("T", "Triangles")
add_level_path_require("T", "S")
add_level_path_require("S", "H")

add_level_to_chapter("Assembly II", "Octagon", -0.5, 0.0)
add_level_to_chapter("Assembly II", "Empty Inside", -0.1, 0.4)
add_level_to_chapter("Assembly II", "More Triangles", 0.0, 0.0)
add_level_to_chapter("Assembly II", "Staircase", 0.5, 0.0)
add_level_to_chapter("Assembly II", "Spiral", 0.4, -0.4)

add_level_path_require("Octagon", "Empty Inside")
add_level_path_require("Octagon", "More Triangles")
add_level_path_require("More Triangles", "Staircase")
add_level_path_require("More Triangles", "Spiral")

add_level_to_chapter("Patterns", "Zebra", -0.4, 0.0)
add_level_to_chapter("Patterns", "Porthole", 0.0, 0.4)
add_level_to_chapter("Patterns", "Fish", 0.0, -0.4)
add_level_to_chapter("Patterns", "Quilt", 0.4, 0.0)

add_level_path_require("Zebra", "Porthole")
add_level_path_require("Zebra", "Fish")
add_level_path_require("Porthole", "Quilt")
add_level_path_require("Fish", "Quilt")

set_next_level_hint("Zebra", "Porthole")
set_next_level_hint("Porthole", {"Fish", "Quilt"})
set_next_level_hint("Fish", {"Porthole", "Quilt"})

add_level_to_chapter("Assembly III", "Disco", -0.5, 0.0)
add_level_to_chapter("Assembly III", "Bullseye", -0.1, -0.4)
add_level_to_chapter("Assembly III", "Lattice", 0.0, 0.0)
add_level_to_chapter("Assembly III", "Antenna", 0.5, 0.0)
add_level_to_chapter("Assembly III", "Carpet", 0.4, 0.4)
add_level_to_chapter("Assembly III", "Sword", -0.1, 0.4)

add_level_path_require("Disco", "Bullseye")
add_level_path_require("Disco", "Lattice")
add_level_path_require("Lattice", "Antenna")
add_level_path_require("Lattice", "Carpet")
add_level_path_require("Disco", "Sword")

add_level_to_chapter("Dynamical Systems", "Multiplexer", -0.5, 0.0)
add_level_to_chapter("Dynamical Systems", "Reactor", -0.2, 0.3)
add_level_to_chapter("Dynamical Systems", "Asymmetric Mutex", 0.1, 0.2)
add_level_to_chapter("Dynamical Systems", "Completor", -0.2, -0.3)
add_level_to_chapter("Dynamical Systems", "Dumper", 0.2, -0.3)
add_level_to_chapter("Dynamical Systems", "Switcher", 0.5, -0.3)
add_level_to_chapter("Dynamical Systems", "Copycat", 0.4, 0.3)

add_level_path_require("Multiplexer", "Reactor")
add_level_path_require("Multiplexer", "Completor")
add_level_path_require("Completor", "Dumper")
add_level_path_require("Completor", "Asymmetric Mutex")
add_level_path_require("Asymmetric Mutex", "Copycat")
add_level_path_require("Dumper", "Switcher")

add_level_to_chapter("Advanced Dynamics", "Toggle", -0.5, 0.0)
add_level_to_chapter("Advanced Dynamics", "Turtle", 0.1, 0.4)
add_level_to_chapter("Advanced Dynamics", "Reorientation Station", 0.2, 0.0)
add_level_to_chapter("Advanced Dynamics", "Sorter", 0.1, -0.4)

add_level_path_require("Toggle", "Turtle")
add_level_path_require("Toggle", "Reorientation Station")
add_level_path_require("Toggle", "Sorter")

add_level_to_chapter("Digitalia", "Complement", -0.5, 0.0)
add_level_to_chapter("Digitalia", "Locksmith", -0.15, 0.0)
add_level_to_chapter("Digitalia", "Memory", -0.1, -0.3)
add_level_to_chapter("Digitalia", "Parity", -0.2, 0.3)
add_level_to_chapter("Digitalia", "Count", 0.2, 0.5)
add_level_to_chapter("Digitalia", "Xor", 0.2, -0.1)
add_level_to_chapter("Digitalia", "Adder", 0.5, -0.2)
add_level_to_chapter("Digitalia", "Orientation Duplication", 0.5, 0.2)

add_level_path_require("Complement", "Memory")
add_level_path_require("Complement", "Parity")
add_level_path_require("Complement", "Locksmith")
add_level_path_require("Parity", "Xor")
add_level_path_require("Parity", "Count")
add_level_path_require("Xor", "Adder")
add_level_path_require("Xor", "Orientation Duplication")

add_level_to_chapter("Arcana", "Alien Tech", -0.5, 0.0)
add_level_to_chapter("Arcana", "Magic Trick", -0.3, -0.2)
add_level_to_chapter("Arcana", "Magicker Tricker", 0.0, 0.0)
add_level_to_chapter("Arcana", "Untangler", 0.2, 0.0)
add_level_to_chapter("Arcana", "Disentanglement", 0.5, 0.0)
add_level_to_chapter("Arcana", "Weld Inspector", 0.1, -0.4)

add_level_path_require("Alien Tech", "Magic Trick")
add_level_path_require("Magic Trick", "Magicker Tricker")
add_level_path_require("Magic Trick", "Weld Inspector")
add_level_path_require("Magicker Tricker", "Untangler")
add_level_path_require("Untangler", "Disentanglement")


add_level_to_chapter("Nortalvania", "Nortal Detector", -0.5, 0.0)
add_level_to_chapter("Nortalvania", "Mysterious Motion", -0.1, 0.0)
add_level_to_chapter("Nortalvania", "Dip Switch", -0.2, -0.3)
add_level_to_chapter("Nortalvania", "Rescue", 0.2, -0.3)
add_level_to_chapter("Nortalvania", "Norbox", -0.3, 0.3)
add_level_to_chapter("Nortalvania", "Trinort", 0.0, 0.3)
add_level_to_chapter("Nortalvania", "Nnnnnortal", 0.3, 0.3)

add_level_path_require("Nortal Detector", "Mysterious Motion")
add_level_path_require("Nortal Detector", "Dip Switch")
add_level_path_require("Dip Switch", "Rescue")
add_level_path_require("Nortal Detector", "Norbox")
add_level_path_require("Norbox", "Trinort")
add_level_path_require("Trinort", "Nnnnnortal")

add_chapter_requirement("Practice", n_from_chapter("Academy", 7))
add_chapter_requirement("Advanced Academy", n_from_chapter("Practice", 3))
add_chapter_requirement("Practicum", n_from_chapter("Practice", 3))
local base_level_requiements = {
  n_from_chapter("Practicum", 3),
  prerequisite_level("Mutex")
}
add_chapter_requirement("Assembly I", base_level_requiements)
add_chapter_requirement("Intermezzo", base_level_requiements)
add_chapter_requirement("Dynamical Systems", base_level_requiements)
add_chapter_requirement("Sandbox", base_level_requiements)
add_chapter_requirement("Extras Tutorial", prerequisite_level("Mutex"))

add_chapter_requirement("Patterns", n_from_chapter("Assembly I", 4))
add_chapter_requirement("Assembly II", n_from_chapter("Assembly I", 4))
add_chapter_requirement("Nortalvania", {
  n_from_chapter("Assembly I", 4),
  n_from_chapter("Dynamical Systems", 5)
})
add_chapter_requirement("Advanced Dynamics", n_from_chapter("Dynamical Systems", 5))


add_chapter_requirement("Assembly III", n_from_chapter("Assembly II", 4))
add_chapter_requirement("Arcana", {
  n_from_chapter("Nortalvania", 4),
  n_from_chapter("Advanced Dynamics", 3)
})
add_chapter_requirement("Digitalia", n_from_chapter("Advanced Dynamics", 3))

add_chapter_description("Academy", "A place to learn the ropes of portal engineering.")
add_chapter_description("Practice", "A place for independent dabbling in portal engineering.")
add_chapter_description("Practicum", "First forays into applied portals.")
add_chapter_description("Intermezzo", "First steps into using electricity.")
add_chapter_description("Advanced Academy", "Learn to build advanced machines using digital signals.")
add_chapter_description("Extras Tutorial", "Learn to use helpful, but non-critical tools.")
add_chapter_description("Dynamical Systems", "Build systems capable of responding to inconsistent inputs.")
add_chapter_description("Assembly I", "Build factories producing the same product from the same ingredients, over and over.")
add_chapter_description("Assembly II", "More advanced factory building, requiring careful considerations of symmetry.")
add_chapter_description("Assembly III", "Build factories producing the most advanced products.")
add_chapter_description("Patterns", "Build factories that create objects matching both shape and texture.")
add_chapter_description("Advanced Dynamics", "Machines implementing even more advanced routines based on their inputs.")
add_chapter_description("Digitalia", "Process digital inputs and outputs, bringing factories into the modern age.")
add_chapter_description("Nortalvania", "Process a new material that cannot be passed through portals.")
add_chapter_description("Arcana", "Exploit minute quirks in portal technology to cut apart space and perform impossible tasks.")
add_chapter_description("Sandbox", "A large empty space to play around in. (Not a puzzle)")

--Academy

add_level_description("First Steps", "A first introduction to creating factories")
add_level_description("Building Bridges", "Techniques for holding pieces together")
add_level_description("A Portal", "????")
add_level_description("Rotations and Flips", "Learn to reorient pieces of your factories")
add_level_description("Portals!", "Place your very first portal!")
add_level_description("More Portals!", "Place your very second portal!")
add_level_description("Putting It Together", "Techniques for creating larger works in factories")

--Practice

add_level_description("Portal Practice", "Build paradoxical machinery by twisting space in new ways")
add_level_description("The Box Exam", "Build a box")
add_level_description("MultiWeld", "Put simple pieces together")
add_level_description("Column", "Like a row, but vertical")

--Practicum

add_level_description("L", "Practical applications of 2 + 2 = 4.")
add_level_description("Rocket", "Perform final assembly of a rocket from its engines, body, and nose.")
add_level_description("Separator", "Take a series of rods of height 1 or 2 and sort them.")
add_level_description("Trident", "Build a very large fork.")
add_level_description("Assembly", "Rotate and flip shapes to construct a bigger composite.")

--Intermezzo

add_level_description("Quadsort", "Sort four kinds of input.")
add_level_description("Piston Mover", "Move some blocks the old fashioned way.")
add_level_description("Warpless Column", "Create a column without using portals.")

--Advanced Academy

add_level_description("Sensitivity", "Learn the fundamentals of creating systems that react to their environment.")
add_level_description("Electric Motion", "An introduction to pistons.")
add_level_description("Mutex", "Magnets???")

--Extras Tutorial

add_level_description("Pin", "Learn to keep stuff from moving.")
add_level_description("Invisible Arms", "A demonstration of the interplay of pistons and sensors.")
add_level_description("Nodes", "Keeping wiring tidy")
add_level_description("Resizer", "Make levels bigger or smaller to fit your machines.")

--Dynamical Systems

add_level_description("Multiplexer", "Feed multiple identical outputs from a single input.")
add_level_description("Reactor", "Precisely time actions to keep a reactor running.")
add_level_description("Asymmetric Mutex", "Pair off big and small blocks.")
add_level_description("Completor", "Fill in the gaps in shapes.")
add_level_description("Dumper", "Separate a block from its container.")
add_level_description("Switcher", "Change the position of a block in a container.")
add_level_description("Copycat", "Produce a copy of a sequence of input rods.")
add_achievement_to_level("Copycat", "Sensorless")

--Assembly I

add_level_description("Little Triangles", "A useful shape.")
add_level_description("Sequencer", "Build a rod patterned with two colors.")
add_level_description("Color Box", "Build a box patterned with two colors")
add_level_description("Triangles", "Build a triangle of triangles.")
add_level_description("T", "Produce the letter 'T'")
add_level_description("S", "Produce the letter 'S'")
add_level_description("H", "Produce the letter 'H'")

--Assembly II

add_level_description("Octagon", "Build octagons.")
add_level_description("Empty Inside", "Build a hollow box.")
add_level_description("More Triangles", "Build a really big triangle.")
add_level_description("Staircase", "Build a repeating diagonal pattern.")
add_level_description("Spiral", "Create a large spiral pattern.")

--Assembly III

add_level_description("Disco", "Create a floor using four groovy colors.")
add_level_description("Bullseye", "Make a target out of two colors.")
add_level_description("Lattice", "Create a square lattice.")
add_level_description("Antenna", "Make a large self-similar antenna.")
add_level_description("Carpet", "Make a box out of boxes.")
add_level_description("Sword", "Make a sword!")

--Advanced Dynamics

add_level_description("Toggle", "Build a machine responding to a sequence of inputs and holding some memory.")
add_level_description("Turtle", "Transform a discrete representation of rod lengths into actual rods.")
add_level_description("Reorientation Station", "Automatically rotate inputs into the desired orientation.")
add_level_description("Sorter", "Unscramble randomized inputs.")

--Digitalia

add_level_description("Complement", "Implement the simplest operation on binary sequences.")
add_level_description("Locksmith", "Build a mating key for a series of locks.")
add_achievement_to_level("Locksmith", "Nortal Lock", prerequisite_level("Nortal Detector"))
add_achievement_to_level("Locksmith", "Nortal Key", prerequisite_level("Nortal Detector"))
add_level_description("Memory", "Build a machine that can remember and reconstruct something it's seen before.")
add_level_description("Parity", "Sort rods based on whether they have an even or odd number of bumps.")
add_level_description("Count", "Sort rods based on whether they have four or more bumps.")
add_level_description("Xor", "Implement a bitwise operation on two input sequences.")
add_level_description("Adder", "Implement binary addition.")
add_level_description("Orientation Duplication", "Rotate one object to match another.")

--Nortalvania

add_level_description("Nortal Detector", "Separate a strange new kind of block from the normal ones.")
add_level_description("Mysterious Motion", "Guide nortals over an abyss without pistons or conveyors.")
add_level_description("Dip Switch", "Move an interior component of a larger object.")
add_level_description("Rescue", "Rescue a small block from a twisting passageway.")
add_level_description("Norbox", "Build a box without passing it through portals.")
add_level_description("Trinort", "Build a triangle without passing it through portals.")
add_level_description("Nnnnnortal", "Build an 'N' without passing it through portals.")

--Arcana

add_level_description("Alien Tech", "Discover new quirks of portal technology.")
add_level_description("Magic Trick", "Cut apart space to remove a block from its surroundings.")
add_level_description("Magicker Tricker", "Cut apart space even more to remove a nortal from its surroundings.")
add_level_description("Untangler", "Pull apart two interlocked parts.")
add_level_description("Disentanglement", "Pull apart two random interlocked parts.")
add_level_description("Weld Inspector", "Sort good welds from bad welds.")

--Patterns

add_level_description("Zebra", "Dazzle predators with striped patterns.")
add_level_description("Fish", "Create beautiful paintings of fish.")
add_level_description("Porthole", "Use portals to build portholes.")
add_level_description("Quilt", "Make a quilt out copies of a single component.")
